/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.lifecycle.api.event;

import net.minecraft.server.MinecraftServer;
import org.quiltmc.qsl.base.api.event.Event;
import org.quiltmc.qsl.base.api.event.EventAwareListener;

public final class ServerLifecycleEvents {
    public static final Event<Starting> STARTING = Event.create(Starting.class, callbacks -> server -> {
        for (Starting callback : callbacks) {
            callback.startingServer(server);
        }
    });
    public static final Event<Ready> READY = Event.create(Ready.class, callbacks -> server -> {
        for (Ready callback : callbacks) {
            callback.readyServer(server);
        }
    });
    public static final Event<Stopping> STOPPING = Event.create(Stopping.class, callbacks -> server -> {
        for (Stopping callback : callbacks) {
            callback.stoppingServer(server);
        }
    });
    public static final Event<Stopped> STOPPED = Event.create(Stopped.class, callbacks -> server -> {
        for (Stopped callback : callbacks) {
            callback.exitServer(server);
        }
    });

    private ServerLifecycleEvents() {
    }

    @FunctionalInterface
    public static interface Stopped
    extends EventAwareListener {
        public void exitServer(MinecraftServer var1);
    }

    @FunctionalInterface
    public static interface Stopping
    extends EventAwareListener {
        public void stoppingServer(MinecraftServer var1);
    }

    @FunctionalInterface
    public static interface Ready
    extends EventAwareListener {
        public void readyServer(MinecraftServer var1);
    }

    @FunctionalInterface
    public static interface Starting
    extends EventAwareListener {
        public void startingServer(MinecraftServer var1);
    }
}

